/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.api.behaviour.movement;

import com.zurrtum.create.api.registry.SimpleRegistry;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public abstract class MovementBehaviour {
    public static final SimpleRegistry<class_2248, MovementBehaviour> REGISTRY = SimpleRegistry.create();
    public Object attachRender;

    public <T> T getAttachRender() {
        return (T)this.attachRender;
    }

    public boolean isActive(MovementContext context) {
        return !context.disabled;
    }

    public void tick(MovementContext context) {
    }

    public void startMoving(MovementContext context) {
    }

    public void visitNewPosition(MovementContext context, class_2338 pos) {
    }

    public class_243 getActiveAreaOffset(MovementContext context) {
        return class_243.field_1353;
    }

    @Nullable
    public class_1799 canBeDisabledVia(MovementContext context) {
        class_2248 block = context.state.method_26204();
        if (block == null) {
            return null;
        }
        return new class_1799((class_1935)block);
    }

    public void onDisabledByControls(MovementContext context) {
        this.cancelStall(context);
    }

    public boolean mustTickWhileDisabled() {
        return false;
    }

    @Deprecated(since="6.0.9", forRemoval=true)
    public void dropItem(MovementContext context, class_1799 stack) {
        this.collectOrDropItem(context, stack);
    }

    public void collectOrDropItem(MovementContext context, class_1799 stack) {
        int insert;
        if (((Boolean)AllConfigs.server().kinetics.moveItemsToStorage.get()).booleanValue() && (insert = context.contraption.getStorage().getAllItems().insert(stack)) > 0) {
            int count = stack.method_7947();
            if (insert == count) {
                stack = class_1799.field_8037;
            } else {
                stack.method_7939(count);
            }
        }
        if (stack.method_7960()) {
            return;
        }
        class_243 vec = context.position;
        if (vec == null) {
            return;
        }
        class_1542 itemEntity = new class_1542(context.world, vec.field_1352, vec.field_1351, vec.field_1350, stack);
        itemEntity.method_18799(context.motion.method_1031(0.0, 0.5, 0.0).method_1021((double)(context.world.field_9229.method_43057() * 0.3f)));
        context.world.method_8649((class_1297)itemEntity);
    }

    public void onSpeedChanged(MovementContext context, class_243 oldMotion, class_243 motion) {
    }

    public void stopMoving(MovementContext context) {
    }

    public void cancelStall(MovementContext context) {
        context.stall = false;
    }

    public void writeExtraData(MovementContext context) {
    }

    public boolean disableBlockEntityRendering() {
        return false;
    }
}

